<?php
date_default_timezone_set('UTC');
set_time_limit(15000);
$maindir = './alldata/inv_earnings/';
$k = 0;

include 'investing_codes.php';

//$Q[$k++] = array(6464,"/equities/activision-inc",'NASDAQ100/SnP500/R1000VALUE','XYZ', '');
//$Q[$k++] = array(6373,"/equities/adobe-sys-inc",'NASDAQ100/SnP500/R1000GROWTH','XYZ', '');

$file_date = date("Y-m-d");
//$file_date = "2021-11-27";

$start = 10410;
$end = count($Q);
//$end = 2950;
//$end = 3;

$DESC = array();
$abortfile = $maindir . 'ABORT.txt';


$lockfile = $maindir . 'LOCK1.txt';
$listfile = $maindir . 'LIST_' . $file_date . '.txt';
$descfile = $maindir . 'DESC_' . $file_date . '.txt';
$my_pid = getmypid();

if (file_exists($lockfile)) {
  echo 'IS LOCKED ' . $my_pid  . ' ' . date("Y-m-d H:i:s") . ' REMOVE MANUALY ' . $lockfile ; 
  die;
} else {
  $flock = fopen($lockfile ,"a"); 
  fwrite($flock, $my_pid . '|' . date("Y-m-d H:i:s") . "\n");
  fclose ($flock);
}

$resfile = $maindir . 'Earn_' . $file_date . '.txt';
$logfile = $maindir . 'LOG_' . $file_date . '.txt';
$excelfile = $maindir . 'EXCEL_' . $file_date . '.txt';

$fres = fopen($resfile ,"a");
$flog = fopen($logfile ,"a");
$fexc = fopen($excelfile ,"a");




for($i = $start; $i<$end; $i++){
    if (file_exists($abortfile)) {
        fwrite($flog, date("Y-m-d H:i:s") . '|ABORTED' . "\n");
        die;
    }
    if ($Q[$i][3] == 'XYZ') {
        $DESC[$i] = str_pad($i, 5, '0', STR_PAD_LEFT) . '|' . $Q[$i][0];
        $lbt = get_code($i);
        $lb = $lbt[0];
        $ttmp = $lbt[1];
        $flist = fopen($listfile ,"a"); 
        fwrite($flist, $lb  . "\n");
        fclose($flist);
        $fdesc = fopen($descfile ,"a"); 
        fwrite($fdesc, $DESC[$i] . "\n");
        fclose($fdesc);
        //die;
    }
    $pair = $Q[$i][0]; $code = $Q[$i][2] . '|' . $Q[$i][3] . '|' . $Q[$i][4] . '|' . $Q[$i][5];
    $rmove = $code . '|' . $pair . '|';
    $maininfo = $Q[$i][3] . '|' . $Q[$i][11] . '|' . $Q[$i][12] . '|' . $Q[$i][13] . '|' . $Q[$i][14] . '|' . $Q[$i][15];
    $x = get_all($pair,$code);
    $nbr = count($x);
    $FIRST = '';
    $SECOND = '';
    $THIRD = '';
    $FORTH = '';
    $FIFTH = '';
    $SIXTH = '';
    $SEVENTH = '';
    $EIGHTH = '';
    foreach ($x as $key => &$val) {
       $cval = str_replace("\r", "",$val);
       if (($SEVENTH != '') && ($EIGHTH == '')) $EIGHTH = str_replace($rmove, "", $cval);
       if (($SIXTH != '') && ($SEVENTH == '')) $SEVENTH = str_replace($rmove, "", $cval);
       if (($FIFTH != '') && ($SIXTH == '')) $SIXTH = str_replace($rmove, "", $cval);
       if (($FORTH != '') && ($FIFTH == '')) $FIFTH = str_replace($rmove, "", $cval);
       if (($THIRD != '') && ($FORTH == '')) $FORTH = str_replace($rmove, "", $cval);
       if (($SECOND != '') && ($THIRD == '')) $THIRD = str_replace($rmove, "", $cval);
       if (($FIRST != '') && ($SECOND == '')) $SECOND = str_replace($rmove, "", $cval);
       if ($FIRST == '') $FIRST = str_replace($rmove, "", $cval);

       fwrite($fres, str_pad($i, 5, '0', STR_PAD_LEFT) . '|' . $cval . "\n");
    }
    $tmp = date("Y-m-d H:i:s") . '|' . str_pad($i, 5, '0', STR_PAD_LEFT) . '|' . $pair . '|' . $maininfo . '|' . $nbr . '|' . $FIRST . '|' . $SECOND;
    $ttmp = date("Y-m-d H:i:s") . '|' . str_pad($i, 5, '0', STR_PAD_LEFT) . '|' . $ttmp . '|' . $nbr . '|' . $FIRST . '|' . $SECOND . '|' . $THIRD . '|' . $FORTH . '|' . $FIFTH . '|' . $SIXTH . '|' . $SEVENTH . '|' . $EIGHTH;
    fwrite($flog, $tmp . "\n");
    echo $tmp . '<br/>'; sleep(1);
    fwrite($fexc, $ttmp . "\n");
}    

fclose ($flog);
fclose ($fres);
fclose ($fexc);

function get_trends($txt){
    $res = '';
    $t1 = get_string_between($txt, 'class="instrument-tech-summary_table-scroll_', '</table>');
    $t2 = get_string_between($t1, '>', '</tbody>');
    $t3 = str_replace("</th>", "</td>", $t2);
    $t4 = explode('</tr>', $t3);
    $t = array();
    $headnb = 0;
    $DailyCol = '';
    $WeeklyCol = '';
    $MonthlyCol = '';
    $Averages = '';
    $Technicals = '';
    $SummaryLine = '';
    $resu = array('','','', '','','', '','','');
    for($i = 0; $i < count($t4); $i++){
        $t5 = explode('</td>', $t4[$i]);
        if ($headnb == 0) $headnb = count($t5);
        $t[$i] = array_fill(0, $headnb, '');
        for($j = 0; $j < count($t5); $j++){
            $x = strip_tags($t5[$j]);
            $t[$i][$j] = $x;
            if (($DailyCol == '') &&  ($x == 'Daily')) $DailyCol = $j;
            if (($WeeklyCol == '') &&  ($x == 'Weekly')) $WeeklyCol = $j;
            if (($MonthlyCol == '') &&  ($x == 'Monthly')) $MonthlyCol = $j;
            if (($SummaryLine == '') &&  ($j == 0)  &&  ($x == 'Summary')) $SummaryLine = $i;
            if (($Averages == '') &&  ($j == 0)  &&  ($x == 'Moving Averages')) $Averages = $i;
            if (($Technicals == '') &&  ($j == 0)  &&  ($x == 'Technical Indicators')) $Technicals = $i;
            if ($Averages == $i){
                if (($j == $DailyCol) && ($DailyCol != ''))$resu[0] = $x;
                if (($j == $WeeklyCol) && ($WeeklyCol != '')) $resu[1] = $x;
                if (($j == $MonthlyCol) && ($MonthlyCol != '')) $resu[2] = $x;
            }
            if ($Technicals == $i){
                if (($j == $DailyCol) && ($DailyCol != ''))$resu[3] = $x;
                if (($j == $WeeklyCol) && ($WeeklyCol != '')) $resu[4] = $x;
                if (($j == $MonthlyCol) && ($MonthlyCol != '')) $resu[5] = $x;
            }
            if ($SummaryLine == $i){
                if (($j == $DailyCol) && ($DailyCol != ''))$resu[6] = $x;
                if (($j == $WeeklyCol) && ($WeeklyCol != '')) $resu[7] = $x;
                if (($j == $MonthlyCol) && ($MonthlyCol != '')) $resu[8] = $x;
            }
        }   
    }
    $resust = implode("|", $resu);
    return $resust;
}

function get_code($i){
    global $Q, $DESC;
    $xurl = $Q[$i][1];
    $pair = $Q[$i][0];
    $index = $Q[$i][2];
    $url = 'https://www.investing.com' . $xurl;
    //echo $url;
    $tmp = file_get_contents($url);
    $label = str_replace(",", " ", str_replace("|", " ", get_string_between($tmp, '<title>', '</title>')));
    if ($label == ''){
        sleep(1);
        $tmp = file_get_contents($url);
        $label = str_replace(",", " ", str_replace("|", " ", get_string_between($tmp, '<title>', '</title>')));        
    }
    $ticker = get_string_between($label, ' (', ') ');
    $isin = get_string_between($tmp, 'isin-value">', '<');
    $lastprice = get_string_between($tmp, 'instrument-price-last">', '</');
    $cur = get_string_between(get_string_between($tmp, '>Currency in', '</div>'), 'font-bold">', '<');
    $ind = get_string_between(get_string_between($tmp, 'Industry</div>', '</div>'), 'underline">', '<');
    $sect = get_string_between(get_string_between($tmp, 'Sector</div>', '</div>'), 'underline">', '<');
    $emp = get_string_between(get_string_between($tmp, 'Employees</div>', '/div>'), 'font-bold">', '<');
    $market = get_string_between(get_string_between($tmp, 'Market</div>', '</div>'), 'underline">', '<');
    $mcp = strip_tags(get_string_between(get_string_between($tmp, 'data-test="marketCap"', '</div>'), 'font-bold">', '</dd>'));
    $mcp_num = cv_tonum($mcp);
    $volu3M = strip_tags(get_string_between(get_string_between($tmp, 'data-test="avgVolume"', '</div>'), 'font-bold">', '</dd>'));
    $ret1Y = strip_tags(get_string_between(get_string_between($tmp, 'data-test="oneYearReturn"', '</div>'), 'font-bold">', '</dd>'));
    $rng52W = strip_tags(get_string_between(get_string_between($tmp, 'data-test="weekRange"', '</div>'), 'font-bold">', '</dd>'));
    $rngDay = strip_tags(get_string_between(get_string_between($tmp, 'data-test="dailyRange"', '</div>'), 'font-bold">', '</dd>'));
    $EPS = strip_tags(get_string_between(get_string_between($tmp, 'data-test="eps"', '</div>'), 'font-bold">', '</dd>'));
    $revenue = strip_tags(get_string_between(get_string_between($tmp, 'data-test="revenue"', '</div>'), 'font-bold">', '</dd>'));
    $revenue_num = cv_tonum($revenue);
    $PERatio = strip_tags(get_string_between(get_string_between($tmp, 'data-test="ratio"', '</div>'), 'font-bold">', '</dd>'));
    $NextEarnDate = strip_tags(get_string_between(get_string_between($tmp, 'nextEarningDate', '</div>'), 'font-bold">', '</dd>'));
    $NextEDate = date("Y-m-d",strtotime($NextEarnDate));
    $sho = str_replace(",", "", strip_tags(get_string_between(get_string_between($tmp, 'sharesOutstanding', '</div>'), 'font-bold">', '</dd>')));
    $beta = strip_tags(get_string_between(get_string_between($tmp, 'beta', '</div>'), 'font-bold">', '</dd>'));
    $PrevClose = strip_tags(get_string_between(get_string_between($tmp, 'prevClose', '</div>'), 'font-bold">', '</dd>'));
    $dividTMP = strip_tags(get_string_between(get_string_between($tmp, 'data-test="dividend"', '</dd>'), 'font-bold">', '</div>'));
    $divT = explode("(", $dividTMP);
    $divid = $divT[0]; $dividYield = '';
    if (count($divT) > 1) $dividYield = str_replace(")", "", $divT[1]);
    $description = str_replace("|", "", str_replace("\n", "", get_string_between(get_string_between($tmp, '<p class="company-profile_profile', '</p>') . '<', '>', '<')));
    $DESC[$i] = str_pad($i, 5, '0', STR_PAD_LEFT) . '|' . $pair . '|' . $ticker . '|' . $isin . '|' . $sect . '|' . $ind . '|' . $description; 
    
    $trends = get_trends($tmp);
    //echo $trends . '<br/>';

    $r[0] = $label;
    $r[1] = $ticker;
    $r[2] = $isin;
    $r[3] = $cur;
    $r[4] = $ind;
    $r[5] = $sect;
    $r[6] = $market;
    $r[7] = $emp;
    //var_dump($r); die;
    $Q[$i] = array($pair, $xurl,$index, $ticker,$cur,$sect,$ind,$market,$isin,$emp, $label, $mcp, $mcp_num, $lastprice, $volu3M, $ret1Y, $rng52W, $rngDay, $PrevClose, $sho, $beta, $PERatio, $revenue, $revenue_num, $EPS, $divid, $dividYield, $NextEarnDate, $NextEDate, $trends);
    $tmp = array($xurl,$index, $ticker,$cur,$sect,$ind,$market,$isin, $emp, $label, $mcp, $mcp_num, $lastprice, $volu3M, $ret1Y, $rng52W, $rngDay, $PrevClose, $sho,$beta, $PERatio, $revenue, $revenue_num, $EPS, $divid, $dividYield, $NextEarnDate, $NextEDate);
    $res[0] = '$Q[$k++] = array(' . $pair . ',"' . implode('","',$tmp) . '");';
    $res[1] = $pair . '|' . implode('|', $tmp) . '|' . $trends;
    return $res;
}


function get_all($pair, $code){
    $tdate = date("Y-m-d");
    $cond = true; $nbloops = 0;
    $nbx = 0;
    
    $x = get_earnings($pair, $tdate, $code);
    do {
       $x = get_earnings($pair, $tdate, $code);
       $cond = false;
       if ($x[0] > 0){
           foreach ($x[3] as $key => &$val) {
               $res[$nbx++] = $val;
           }
           if ($x[2]){
               $cond = ($nbloop < 20);
               $tdate = $x[1];
           }
       }
       $nbloop++;
    } while ($cond);
    return $res;
}

function cv_tonum($x){
    $res = $x;
    if (strpos($x, 'B') !== false){
        $res = str_replace('B', '', $x) * 1000000000;
    }
    if (strpos($x, 'T') !== false){
        $res = str_replace('T', '', $x) * 1000000000000;
    }
    if (strpos($x, 'M') !== false){
        $res = str_replace('M', '', $x) * 1000000;
    }
    if (strpos($x, 'K') !== false){
        $res = str_replace('K', '', $x) * 1000;
    }
    return $res;
}

function get_earnings($pair, $lastd, $code){

    $url = 'https://www.investing.com/equities/morehistory';
    
    $data = array('pairID' => $pair, 'last_timestamp' => $lastd);
    
    $additional_headers = array( 
       'Accept: application/json, text/javascript, */*; q=0.01',
       'Host: www.investing.com',
       'Accept-language: en-GB,en-US;q=0.9,en;q=0.8',
       'Content-Type: application/x-www-form-urlencoded',
       'Accept-Encoding: deflate',
       'Origin: https://www.investing.com',
       'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36',
       'X-Requested-With: XMLHttpRequest',
       //'Referer: https://www.investing.com/equities/baidu.com-earnings',
       'Connection: keep-alive',
       'Sec-Fetch-Dest: empty',
       'Sec-Fetch-Mode: no-cors',
       'Sec-Fetch-Site: same-origin',
       'Alt-Used: www.investing.com',
       'TE: trailers',
       'Pragma: no-cache',
       'Cache-Control: no-cache',
    );
    
    $theheader = implode("\r\n",$additional_headers );
    //echo $theheader; die;
    // use key 'http' even if you send the request to https://...
    $options = array(
        'http' => array(
            'header'  => $theheader,
            'method'  => 'POST',
            'content' => http_build_query($data)
        )
    );
    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);
    if ($result === FALSE) { /* Handle error */ echo 'ERROR';}
    $result = str_replace("\\u00a0\\r", "", $result);
    $result = str_replace("\\n", "", $result);
    //echo $result . '<br/><br/>';
    $x = json_decode($result, true);
    $y = explode('</tr>', $x["historyRows"]);
    $nbl = 0;
    $lastdate = '';
    foreach ($y as $key => &$val) {
         $v = explode('<td', $val);
         $tmp = get_string_between($val, 'stamp="', '"');
         if ($tmp !== '')  {
             $lastdate =$tmp;
             $nb = 0;
             foreach ($v as $key1 => &$val1) {
                 if ($nb >0){
                     $tmp = $tmp . '|' .  str_replace('/&nbsp;&nbsp;', '', get_string_between($val1, '>', '<'));
                 }
                 $nb++;
             }
             $res[$nbl++] = $code . '|' . $pair . '|' . $tmp;
             //echo $tmp . "<br/>\r\n";
         }  
    }   
    $r[0] = $nbl;
    $r[1] = $lastdate;
    $r[2] = $x["hasMoreHistory"];
    $r[3] = $res;
    
    return $r;
}

function get_string_between($string, $start, $end){
    $string = " ".$string;
    $ini = strpos($string,$start);
    if ($ini == 0) return "";
    $ini += strlen($start);
    $len = strpos($string,$end,$ini) - $ini;
    return substr($string,$ini,$len);
}
?>