<?php
//comment below must stay alive
//#BLV-PHP

// set default time zone
date_default_timezone_set('GMT');

// set error reporting
ini_set('error_reporting', E_ALL);

// set error display
ini_set('display_errors', 0);

// include file with DB connection configuration params
$db_config_file_path = './includes/db_config.php';

if (file_exists($db_config_file_path))
{
    require_once($db_config_file_path);
}
else
{
    $db_config = null;
    $db_handler = null;
}

$default_page_url = 'index';

$default_page_url = 'index';


$page_files = array();

$page_files = array(
    1 => array(
        'page_key' => '1',
        'file_name' => 'villa_haweri_estate_at_nihiwatu_sumba.php',
        'page_url' => 'villa_haweri_estate_at_nihiwatu_sumba',
        'has_contact_form' => 0,
    ),
    2 => array(
        'page_key' => '2',
        'file_name' => 'photos_of_haweri_estate.php',
        'page_url' => 'photos_of_haweri_estate',
        'has_contact_form' => 0,
    ),
    3 => array(
        'page_key' => '3',
        'file_name' => 'experience_at_haweri_estate,_sumba.php',
        'page_url' => 'experience_at_haweri_estate,_sumba',
        'has_contact_form' => 0,
    ),
    4 => array(
        'page_key' => '4',
        'file_name' => 'location_of_haweri_estate.php',
        'page_url' => 'location_of_haweri_estate',
        'has_contact_form' => 0,
    ),
    5 => array(
        'page_key' => '5',
        'file_name' => 'retreats_and_events_at_haweri_estate.php',
        'page_url' => 'retreats_and_events_at_haweri_estate',
        'has_contact_form' => 0,
    ),
    6 => array(
        'page_key' => '6',
        'file_name' => 'enquire_and_book_haweri_estate.php',
        'page_url' => 'enquire_and_book_haweri_estate',
        'has_contact_form' => 1,
    ),
);


$PAGE_PLACEHOLDER_VALUES = array();

// get page content
run();

$WEBFORM_CONFIG = 'zzz';
//
// functions
//
function run()
{
    global $default_page_url;

    $p = isset($_REQUEST['pg']) ? strval($_REQUEST['pg']) : 'index';
    $page_details = get_current_page_details($p, $default_page_url);

    // if no details for current page then show 404 error and exit
    if (!$page_details)
    {
        visit_log(false);
        header("HTTP/1.0 404 Not Found");
        die();
    }

    visit_log(true);

    // start output buffering
    ob_start();

    // open database
    open_db_connection();

    // include form code
    $has_contact_form = $page_details['has_contact_form'];

    if ($page_details['has_contact_form'])
    {
        require_once('./includes/contact_form.php');
        // process form before including page content
        WebForm_run();
    }

    // include page content
    $php_file_name = $page_details['file_name'];
    require_once('./pages/'.$php_file_name);

    // get output from buffer
    $content = ob_get_clean();

    // replace placeholders
    $content = replace_placeholders($content, $has_contact_form);

    // finally echo result to browser
    echo $content;

    // close database
    close_db_connection();

    return;
}

function get_current_page_details($current_page_url, $default_page_url)
{
    global $page_files;

    $res = null;
    $res_default = null;
    $res_first = null;

    foreach ($page_files as $k => $page)
    {
        // get details for first page
        if (!$res_first) {
            $res_first = $page;
        }

        // get details for default page
        if ($page['page_url'] == $default_page_url) {
            $res_default = $page;
        }

        // get details for current page
        if ($page['page_url'] == $current_page_url) {
            $res = $page;
            break;
        }
    }

    if (!$res_default) {
        $res_default = $res_first;
    }

    // if we failed to find details for current page then try to use details for default page
    // however if no details for default page then we return very first page
    // finally, if there is no first page (that means no pages at all...NOT VALID SITUATION!), then return null
    if (!$res) {
        $res = $res_default;
    }

    return $res;
}

function visit_log($is_page_found = false)
{
    $s1 = $is_page_found ? 'OK' : '!!!PAGE NOT FOUND!!!';
    $s2 = date('Y-m-d H:i:s')."|".(isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'NA')."|".(isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : 'NA')."|".$s1."\n";

    $base_path = './logs/';
    $file_name = 'visit_'.date('Y-m').'.log';
    $file_path = $base_path . $file_name;

    if (!is_dir($base_path) || !is_writable($base_path)) {
        return;
    }

    $fh = fopen($file_path, 'a+');
    fwrite($fh, $s2);
    fclose($fh);

    return;
}

function prepare_placeholders_content($has_contact_form)
{
    global $PAGE_PLACEHOLDER_VALUES;

    $d = array();

    if ($has_contact_form) {
        $d1 = WebForm_getDataForPlaceholdersContent();
        $d = array_merge($d, $d1);
    }

    if (isset($d['WEBFORM_DATA'])) {
        $d['WEBFORM_DATA'] = json_encode($d['WEBFORM_DATA'], JSON_FORCE_OBJECT);
    }

    $PAGE_PLACEHOLDER_VALUES = $d;

    return;
}

function replace_placeholders($content, $has_contact_form)
{
    global $PAGE_PLACEHOLDER_VALUES;

    prepare_placeholders_content($has_contact_form);

    $regex = "`@@([a-z0-9_]+)@@`siU";

    $num_found = preg_match_all($regex, $content, $m, PREG_OFFSET_CAPTURE);

    if (!$num_found) {
        return $content;
    }

    $res = '';
    $pos_left = 0;
    $pos_right = 0;

    $res = $content;  //IA june 16 2020 PHP 7
    for ($i = 0; $i < $num_found; $i++)
    {
        $orig_str = $m[0][$i][0];
        $offset = $m[0][$i][1];
        $length = mb_strlen($m[0][$i][0]);

        $key = str_replace('@', '', $orig_str);
        $value = isset($PAGE_PLACEHOLDER_VALUES[$key]) ? $PAGE_PLACEHOLDER_VALUES[$key] : '';

        // shift right position
        $pos_right = $offset;

        // add part of text which goes either from begin of text OR from end of previous tag
        //$res .= mb_substr($content, $pos_left, ($pos_right - $pos_left));  //IA Commented june 16 2020 PHP 7

        // add parsed tag content
        //$res .= $value; //IA Commented june 16 2020 PHP 7

        $res = str_replace($orig_str, $value , $res); //IA Addedjune 16 2020 PHP 7 STRING problems
        // shift left position
        $pos_left = $offset + $length;
    }//for

    // add last piece of text to the end
    //$res .= mb_substr($content, $pos_left); //IA Commented june 16 2020 PHP 7

    return $res;
}

function open_db_connection()
{
    global $db_config, $db_handler;

    if (!is_array($db_config) || (is_array($db_config) && empty($db_config['db_userpass'])))
    {
        return;
    }

    $db_handler = mysqli_connect($db_config['db_host'], $db_config['db_username'], $db_config['db_userpass'], $db_config['db_name']);

    // necessary to send this query here, otherwise search of UTF-8 strings (russian text, as example) wont' work
    mysqli_query($db_handler, "SET NAMES utf8");

    return;
}

function close_db_connection()
{
    global $db_handler;

    if ($db_handler)
    {
        mysqli_close($db_handler);
    }

    return;
}