<?php
//comment below must stay alive
//#BLV-PHP

// NB! we must declare variables as global, otherwise they won't go to global scope
global $WEBSITE_VILLA_ID, $WEBFORM_CONFIG, $WEBFORM_DATA, $WEBFORM_SEC_DATA;

define('SEC_OK', 1);
define('SEC_RELOAD', 2);
define('SEC_GETOFF', 3);
define('SEC_ERROR', 4);

$WEBSITE_VILLA_ID = 1668;

$WEBFORM_CONFIG = array(
    'salt' => 'jqhQS$wb',
    'bw_widget_api_key' => '4f712cccd7db46429258c1d8c12ac17b',
    'bw_request_url' => 'http://book.baliluxuryvillas.com/bw.php/bw/bookvilla?',
);

$WEBFORM_DATA = null;
$WEBFORM_SEC_DATA = null;

function WebForm_run()
{
    global $WEBFORM_CONFIG, $WEBFORM_DATA, $WEBSITE_VILLA_ID;

    WebForm_initData();

    // check if we have to do somthing here
    $webform_submitted = isset($_REQUEST['webform_submitted']) ? intval($_REQUEST['webform_submitted']) : 0;

    if (!$webform_submitted)
    {
        $WEBFORM_DATA['data'] = array(
            'values' => array('ar_date' => '', 'nights' => ''),
        );
        return;
    }

    $WEBFORM_DATA['webform_submitted'] = 1;

    //
    // validate security tokens
    //
    $token = isset($_REQUEST['webform_token']) ? strval($_REQUEST['webform_token']) : '';
    $sign = isset($_REQUEST['webform_sign']) ? strval($_REQUEST['webform_sign']) : '';
    $sec_valid = WebForm_verifyFormSecurity($token, $sign);

    if ($sec_valid == SEC_ERROR)
    {
        $WEBFORM_DATA['data'] = array(
            'success' => 0,
            'error' => 1,
            'errors' => array('webform_token'),
        );
        return;
    }

    $input_data = isset($_REQUEST['f']) ? $_REQUEST['f'] : array();
    $req_data = array('Lead' => array(), 'Client' => array());

    //
    // get data
    //
    $confirm_terms = isset($input_data['confirm_terms']) ? intval($input_data['confirm_terms']) : 0;

    $req_data['Lead']['language'] = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : '';
    $req_data['Lead']['utmz'] = isset($_COOKIE['__utmz']) ? $_COOKIE['__utmz'] : '';
    $req_data['Lead']['browser'] = isset($_SERVER['HTTP_USER_AGENT']) ? strtolower($_SERVER['HTTP_USER_AGENT']) : '';
    $req_data['Lead']['ip'] = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '127.0.0.1';

    $req_data['Lead']['nbaddults'] = isset($input_data['nbaddults'])? intval($input_data['nbaddults']) : 0;
    $req_data['Lead']['nbchilds'] = isset($input_data['nbchilds'])? intval($input_data['nbchilds']) : 0;
    $req_data['Lead']['nbinfants'] = isset($input_data['nbinfants'])? intval($input_data['nbinfants']) : 0;
    $req_data['Lead']['occasion'] = isset($input_data['occasion'])? intval($input_data['occasion']) : 0;
    $req_data['Lead']['descr'] = isset($input_data['message'])? strval($input_data['message']) : 0;
    $req_data['Lead']['referrer'] = isset($input_data['referrer'])? strval($input_data['referrer']) : 0;//???? LEAD DOESN'T HAVE referrer FIELD

    $req_data['Client']['first_name'] = isset($input_data['first_name']) ? strval($input_data['first_name']) : '';
    $req_data['Client']['last_name'] = isset($input_data['last_name']) ? strval($input_data['last_name']) : '';
    $req_data['Client']['country_id'] = isset($input_data['country']) ? WebForm_mapCountryCodeToId($input_data['country']) : 0;
    $req_data['Client']['phone1'] = isset($input_data['phone1']) ? strval($input_data['phone1']) : '';
    $req_data['Client']['email1'] = isset($input_data['email1']) ? strval($input_data['email1']) : '';

    date_default_timezone_set('UTC');

    $ar_date = isset($input_data['ar_date'])? strval($input_data['ar_date']) : 0;
    $ar_date_ts = strtotime($ar_date);
    $nights = isset($input_data['nights'])? intval($input_data['nights']) : 0;
    $dp_date_ts = strtotime($ar_date.' +'.$nights.'day');

    $req_data['Lead']['villaday_start_id'] = date('Y-m-d', $ar_date_ts);
    $req_data['Lead']['villaday_end_id'] = date('Y-m-d', $dp_date_ts);

    //
    // validate data
    //
    $errors = array();

    if ($req_data['Lead']['nbaddults'] == -1) {
        $errors['nbaddults'][] = 'Nb. Of Adult must be selected';
    }

    $req_data['Lead']['descr'] = WebForm_cleanText($req_data['Lead']['descr']);
    if (empty($req_data['Lead']['descr'])) {
        $errors['message'][] = 'Message can not be empty';
    }

    $req_data['Client']['first_name'] = WebForm_cleanText($req_data['Client']['first_name']);

    $req_data['Client']['last_name'] = WebForm_cleanText($req_data['Client']['last_name']);
    if (empty($req_data['Client']['last_name'])) {
        $errors['last_name'][] = 'Last Name can not be empty';
    }

    $req_data['Client']['phone1'] = WebForm_cleanText($req_data['Client']['phone1']);
    if (empty($req_data['Client']['phone1'])) {
        $errors['phone1'][] = 'Contact Number can not be empty';
    }

    $req_data['Client']['email1'] = WebForm_cleanText($req_data['Client']['email1']);
    if (empty($req_data['Client']['email1'])) {
        $errors['email1'][] = 'Email can not be empty';
    }
    else
    if (!WebForm_validEmailFormat($req_data['Client']['email1'])) {
        $errors['email1'][] = 'Email has invalid format';
    }

    if (!$req_data['Client']['country_id'] || $req_data['Client']['country_id'] == -1) {
        $errors['country'][] = 'Country must be selected';
    }

    if (!$confirm_terms) {
        $errors['confirm_terms'][] = 'You must read and accept Terms & Conditions';
    }

    if ($nights == -1) {
        $errors['nights'][] = 'Nights must be selected';
    }

    date_default_timezone_set('UTC');

    $min_time = strtotime(date('Y-m-d')) + 86400;
    if ($ar_date_ts < $min_time) {
        $errors['ar_date'][] = 'Arrival Date must be in the future';
    }

    //
    // transfer data to booking server
    //
    if (empty($errors))
    {
        // set widget api key
        $req_data['widget'] = $WEBFORM_CONFIG['bw_widget_api_key'];

        // set villa_id
        $req_data['Lead']['villa_id'] = $WEBSITE_VILLA_ID;

        // set up special variable to enable auto-reply mail sending
        $req_data['send_auto_reply_mail'] = 0;//0 - do not send, 1 - send

        $response = WebForm_transferData($req_data, $submission_errors);
    }

    // if there are errors in input data or errors during transfer
    // check if we need to renew security token
    if (!empty($errors) && ($sec_valid == SEC_RELOAD || $sec_valid == SEC_GETOFF))
    {
        WebForm_renewSecurityData();
    }

    //
    // prepare data to be returned to browser
    //
    $fields_list = array(
        'nbaddults', 'nbchilds', 'nbinfants', 'occasion', 'message', 'referrer',
        'ar_date', 'nights', 'first_name', 'last_name', 'country', 'phone1', 'email1',
    );

    $values = array();
    foreach ($fields_list as $field_name)
    {
        $values[$field_name] = isset($input_data[$field_name]) ? $input_data[$field_name] : '';
    }
    $values['confirm_terms'] = $confirm_terms;

    $res = array(
        'success' => $errors ? 0 : 1,
        'error' => $errors ? 1 : 0,
        'errors' => $errors,
        'values' => $values,
    );

    $WEBFORM_DATA['data'] = $res;

    return;
}

function WebForm_initData()
{
    global $WEBFORM_DATA;

    $d = array();

    $d['WEBFORM_ACTION_URL'] = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $d['WEBFORM_TOKEN'] = WebForm_getSecurityToken();
    $d['WEBFORM_SIGN'] = WebForm_getSecuritySign();
    $d['WEBFORM_COUNTRY_CODE'] = WebForm_getVisitorCountry();

    $d['data'] = array();
    $d['webform_submitted'] = 0;

    $WEBFORM_DATA = $d;

    return;
}

function WebForm_getDataForPlaceholdersContent()
{
    global $WEBFORM_DATA;

    $d = array(
        'WEBFORM_ACTION_URL' => $WEBFORM_DATA['WEBFORM_ACTION_URL'],
        'WEBFORM_TOKEN' => $WEBFORM_DATA['WEBFORM_TOKEN'],
        'WEBFORM_SIGN' => $WEBFORM_DATA['WEBFORM_SIGN'],
        'WEBFORM_COUNTRY_CODE' => $WEBFORM_DATA['WEBFORM_COUNTRY_CODE'],
        'WEBFORM_DATA' => $WEBFORM_DATA['data'],


        'WEBFORM_ID' => 'contact_form_contact1',//!!! @TODO: must be a value changeable through interface
    );

    return $d;
}

function WebForm_transferData($data, &$errors)
{
    global $WEBFORM_CONFIG;

    $errors = array();

    $ch = curl_init($WEBFORM_CONFIG['bw_request_url']);

    //
    // due limitations of cURL library we must encode multidimensional array as string; or use plain array
    // encode data as string
    //
    $str_data = array();

    foreach ($data as $key => $val)
    {
        if ($key == 'Lead' || $key == 'Client') {
            continue;
        }

        $str_data[] = $key.'='.urlencode($val);
    }

    foreach ($data['Client'] as $key => $val) {
        $str_data[] = 'Client['.$key.']='.urlencode($val);
    }

    foreach ($data['Lead'] as $key => $val) {
        $str_data[] = 'Lead['.$key.']='.urlencode($val);
    }

    $str_data = implode('&', $str_data);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $str_data);
    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if ($response === false)
    {
        $errors[] = 'Server returned unknown result';
    }
    else
    if ($http_code != '200')
    {
        $errors[] = 'Server not responding. '.curl_error($ch);
    }
    else
    {
        $response_data = @json_decode($response, true);

        if (!is_array($response_data))
        {
            $errors[] = 'Server result has unknown format';
        }
        else
        {
            //print_r($response_data);
        }
    }

    return $response;
}

function WebForm_cleanText($text)
{
    $text = trim(strip_tags(htmlspecialchars($text)));
    return $text;
}

function WebForm_validEmailFormat($text)
{
    return preg_match("`[-a-zA-Z0-9_.+]+@[a-zA-Z0-9-]+.[a-zA-Z]+`", $text);
}

function WebForm_getSecurityToken()
{
    $data = WebForm_getSecurityData();
    return $data['token'];
}

function WebForm_getSecuritySign()
{
    $data = WebForm_getSecurityData();
    return $data['sign'];
}

function WebForm_getSecurityData()
{
    global $WEBFORM_SEC_DATA;

    if ($WEBFORM_SEC_DATA != null) {
        return $WEBFORM_SEC_DATA;
    }

    $webform_submitted = isset($_REQUEST['webform_submitted']) ? intval($_REQUEST['webform_submitted']) : 0;

    if ($webform_submitted)
    {
        $token = isset($_REQUEST['webform_token']) ? strval($_REQUEST['webform_token']) : '';
        $sign = isset($_REQUEST['webform_sign']) ? strval($_REQUEST['webform_sign']) : '';
        $WEBFORM_SEC_DATA = array('token' => $token, 'sign' => $sign);
    }
    else
    {
        $data = WebForm_createFormSecurity();
        $WEBFORM_SEC_DATA = array('token' => $data[0], 'sign' => $data[1]);
    }

    return $WEBFORM_SEC_DATA;
}

function WebForm_renewSecurityData()
{
    global $WEBFORM_DATA, $WEBFORM_SEC_DATA;

    // create new security data
    $data = WebForm_createFormSecurity();
    $WEBFORM_SEC_DATA = array('token' => $data[0], 'sign' => $data[1]);

    // copy security data to another array
    $WEBFORM_DATA['WEBFORM_TOKEN'] = $WEBFORM_SEC_DATA['token'];
    $WEBFORM_DATA['WEBFORM_SIGN'] = $WEBFORM_SEC_DATA['sign'];

    return;
}

function WebForm_createFormSecurity()
{
    global $WEBFORM_CONFIG;

    $offset = 1376017207;
    $stamp = time() - $offset;
    $sign = WebForm_myHash($stamp . $WEBFORM_CONFIG['salt'], 20, 3);
    $res[0] = $stamp;
    $res[1] = $sign;

    return $res;
}

function WebForm_myHash($string_o, $length = 8, $param = 1)
{
    $str = explode('.' , $string_o);
    $lenx = sizeof($str);

    if ($lenx > 3)
    {
        $string_x = $str[$lenx -3];
    }
    else
    if ($lenx > 1)
    {
        if (($str[$lenx -2] == 'co') && ($lenx == 3))
        {
            $string_x = $str[0];
        }
        else
        {
            $string_x = $str[$lenx -2];
        }
    }
    else
    {
        $string_x = $string_o;
    }

    if ($param == 10) {
        return $string_x;
    }

    // Convert to a string which may contain only characters [0-9a-p]
    $string_x = str_replace('-', '', $string_x);
    $hash = md5('X' . $string_x . '7');
    if ($param > 1) {
        $hash = base_convert($hash, 16, 26);
    }

    // Get part of the string
    if ($param > 2) {
        $hash = substr($hash, -$length);
    }

    // In rare cases it will be too short, add zeroes
    $hash = str_pad($hash, $length, '0', STR_PAD_LEFT);

    // Convert character set from [0-9a-p] to [a-z]
    //if ($param > 3) $hash = strtr($hash, '0123456789', 'qrstuvwxyz');

    return $hash;
}

function WebForm_verifyFormSecurity($stamp, $sign)
{
    global $WEBFORM_CONFIG;

    $offset = 1376017207;
    $nowstamp = gmmktime() - $offset;
    $newsign = WebForm_myHash($stamp . $WEBFORM_CONFIG['salt'], 20, 3);

    $res = SEC_OK;

    if ($newsign == $sign)
    {
        if ($nowstamp > ($stamp + 10))
        {
            if ($nowstamp > ($stamp + 60))
            {
                $res = SEC_RELOAD;
            }
        }
        else
        {
            $res = SEC_GETOFF;
        }
    }
    else
    {
        $res = SEC_ERROR;
    }

    return $res;
}

function WebForm_getVisitorCountry($ip_address_str = '')
{
    global $db_handler;

    $country_code = '??';

    if (!$db_handler) {
        return $country_code;
    }

    if (!$ip_address_str) {
        $ip_address_str = $_SERVER['REMOTE_ADDR'];
    }

    $ip_numeric = WebForm_convertIpAddressToNumber($ip_address_str);

    $sql = "SELECT ct FROM ip_list WHERE ".$ip_numeric." BETWEEN start_ip AND end_ip LIMIT 1";

    if ($result = mysqli_query($db_handler, $sql))
    {
        if ($row = mysqli_fetch_array($result))
        {
            $country_code = $row['ct'];
        }
    }

    return $country_code;
}

function WebForm_convertIpAddressToNumber($ip_address_str)
{
    $i_ip = -1;
    $p = explode('.', $ip_address_str);
    $i_ip = (16777216 * $p[0])  + (65536 * $p[1]) + (256 * $p[2])  + $p[3];

    return $i_ip;
}

function WebForm_mapCountryCodeToId($ISO2)
{
$B0 = 0;
switch ($ISO2) :
case  'AF' : return (7 + $B0);
case  'AL' : return (8 + $B0);
case  'DZ' : return (9 + $B0);
case  'AS' : return (10 + $B0);
case  'AD' : return (11 + $B0);
case  'AO' : return (12 + $B0);
case  'AI' : return (13 + $B0);
case  'AQ' : return (14 + $B0);
case  'AG' : return (15 + $B0);
case  'AR' : return (16 + $B0);
case  'AM' : return (17 + $B0);
case  'AW' : return (18 + $B0);
case  'AU' : return (19 + $B0);
case  'AT' : return (20 + $B0);
case  'AZ' : return (21 + $B0);
case  'BS' : return (22 + $B0);
case  'BH' : return (23 + $B0);
case  'BD' : return (24 + $B0);
case  'BB' : return (25 + $B0);
case  'BY' : return (26 + $B0);
case  'BE' : return (27 + $B0);
case  'BZ' : return (28 + $B0);
case  'BJ' : return (29 + $B0);
case  'BM' : return (30 + $B0);
case  'BT' : return (31 + $B0);
case  'BO' : return (32 + $B0);
case  'BA' : return (33 + $B0);
case  'BW' : return (34 + $B0);
case  'BV' : return (35 + $B0);
case  'BR' : return (36 + $B0);
case  'IO' : return (37 + $B0);
case  'BN' : return (38 + $B0);
case  'BG' : return (39 + $B0);
case  'BF' : return (40 + $B0);
case  'BI' : return (41 + $B0);
case  'KH' : return (42 + $B0);
case  'CM' : return (43 + $B0);
case  'CA' : return (44 + $B0);
case  'CV' : return (45 + $B0);
case  'KY' : return (46 + $B0);
case  'CF' : return (47 + $B0);
case  'TD' : return (48 + $B0);
case  'CL' : return (49 + $B0);
case  'CN' : return (50 + $B0);
case  'CX' : return (51 + $B0);
case  'CC' : return (52 + $B0);
case  'CO' : return (53 + $B0);
case  'KM' : return (54 + $B0);
case  'CG' : return (55 + $B0);
case  'CD' : return (56 + $B0);
case  'CK' : return (57 + $B0);
case  'CR' : return (58 + $B0);
case  'CI' : return (59 + $B0);
case  'HR' : return (60 + $B0);
case  'CU' : return (61 + $B0);
case  'CY' : return (62 + $B0);
case  'CZ' : return (63 + $B0);
case  'DK' : return (64 + $B0);
case  'DJ' : return (65 + $B0);
case  'DM' : return (66 + $B0);
case  'DO' : return (67 + $B0);
case  'EC' : return (68 + $B0);
case  'EG' : return (69 + $B0);
case  'SV' : return (70 + $B0);
case  'GQ' : return (71 + $B0);
case  'ER' : return (72 + $B0);
case  'EE' : return (73 + $B0);
case  'ET' : return (74 + $B0);
case  'FK' : return (75 + $B0);
case  'FO' : return (76 + $B0);
case  'FJ' : return (77 + $B0);
case  'FI' : return (78 + $B0);
case  'FR' : return (79 + $B0);
case  'GF' : return (80 + $B0);
case  'PF' : return (81 + $B0);
case  'TF' : return (82 + $B0);
case  'GA' : return (83 + $B0);
case  'GM' : return (84 + $B0);
case  'GE' : return (85 + $B0);
case  'DE' : return (86 + $B0);
case  'GH' : return (87 + $B0);
case  'GI' : return (88 + $B0);
case  'GR' : return (89 + $B0);
case  'GL' : return (90 + $B0);
case  'GD' : return (91 + $B0);
case  'GP' : return (92 + $B0);
case  'GU' : return (93 + $B0);
case  'GT' : return (94 + $B0);
case  'GN' : return (95 + $B0);
case  'GW' : return (96 + $B0);
case  'GY' : return (97 + $B0);
case  'HT' : return (98 + $B0);
case  'HM' : return (99 + $B0);
case  'VA' : return (100 + $B0);
case  'HN' : return (101 + $B0);
case  'HK' : return (102 + $B0);
case  'HU' : return (103 + $B0);
case  'IS' : return (104 + $B0);
case  'IN' : return (105 + $B0);
case  'ID' : return (106 + $B0);
case  'IR' : return (107 + $B0);
case  'IQ' : return (108 + $B0);
case  'IE' : return (109 + $B0);
case  'IL' : return (110 + $B0);
case  'IT' : return (111 + $B0);
case  'JM' : return (112 + $B0);
case  'JP' : return (113 + $B0);
case  'JO' : return (114 + $B0);
case  'KZ' : return (115 + $B0);
case  'KE' : return (116 + $B0);
case  'KI' : return (117 + $B0);
case  'KP' : return (118 + $B0);
case  'KR' : return (119 + $B0);
case  'KW' : return (120 + $B0);
case  'KG' : return (121 + $B0);
case  'LA' : return (122 + $B0);
case  'LV' : return (123 + $B0);
case  'LB' : return (124 + $B0);
case  'LS' : return (125 + $B0);
case  'LR' : return (126 + $B0);
case  'LY' : return (127 + $B0);
case  'LI' : return (128 + $B0);
case  'LT' : return (129 + $B0);
case  'LU' : return (130 + $B0);
case  'MO' : return (131 + $B0);
case  'MK' : return (132 + $B0);
case  'MG' : return (133 + $B0);
case  'MW' : return (134 + $B0);
case  'MY' : return (135 + $B0);
case  'MV' : return (136 + $B0);
case  'ML' : return (137 + $B0);
case  'MT' : return (138 + $B0);
case  'MH' : return (139 + $B0);
case  'MQ' : return (140 + $B0);
case  'MR' : return (141 + $B0);
case  'MU' : return (142 + $B0);
case  'YT' : return (143 + $B0);
case  'MX' : return (144 + $B0);
case  'FM' : return (145 + $B0);
case  'MD' : return (146 + $B0);
case  'MC' : return (147 + $B0);
case  'MN' : return (148 + $B0);
case  'ME' : return (149 + $B0);
case  'MS' : return (150 + $B0);
case  'MA' : return (151 + $B0);
case  'MZ' : return (152 + $B0);
case  'MM' : return (153 + $B0);
case  'NA' : return (154 + $B0);
case  'NR' : return (155 + $B0);
case  'NP' : return (156 + $B0);
case  'NL' : return (157 + $B0);
case  'AN' : return (158 + $B0);
case  'NC' : return (159 + $B0);
case  'NZ' : return (160 + $B0);
case  'NI' : return (161 + $B0);
case  'NE' : return (162 + $B0);
case  'NG' : return (163 + $B0);
case  'NU' : return (164 + $B0);
case  'NF' : return (165 + $B0);
case  'MP' : return (166 + $B0);
case  'NO' : return (167 + $B0);
case  'OM' : return (168 + $B0);
case  'PK' : return (169 + $B0);
case  'PW' : return (170 + $B0);
case  'PS' : return (171 + $B0);
case  'PA' : return (172 + $B0);
case  'PG' : return (173 + $B0);
case  'PY' : return (174 + $B0);
case  'PE' : return (175 + $B0);
case  'PH' : return (176 + $B0);
case  'PN' : return (177 + $B0);
case  'PL' : return (178 + $B0);
case  'PT' : return (179 + $B0);
case  'PR' : return (180 + $B0);
case  'QA' : return (181 + $B0);
case  'RE' : return (182 + $B0);
case  'RO' : return (183 + $B0);
case  'RU' : return (184 + $B0);
case  'RW' : return (185 + $B0);
case  'SH' : return (186 + $B0);
case  'KN' : return (187 + $B0);
case  'LC' : return (188 + $B0);
case  'PM' : return (189 + $B0);
case  'VC' : return (190 + $B0);
case  'WS' : return (191 + $B0);
case  'SM' : return (192 + $B0);
case  'ST' : return (193 + $B0);
case  'SA' : return (194 + $B0);
case  'SN' : return (195 + $B0);
case  'RS' : return (196 + $B0);
case  'SC' : return (197 + $B0);
case  'SL' : return (198 + $B0);
case  'SG' : return (199 + $B0);
case  'SK' : return (200 + $B0);
case  'SI' : return (201 + $B0);
case  'SB' : return (202 + $B0);
case  'SO' : return (203 + $B0);
case  'ZA' : return (204 + $B0);
case  'GS' : return (205 + $B0);
case  'ES' : return (206 + $B0);
case  'LK' : return (207 + $B0);
case  'SD' : return (208 + $B0);
case  'SR' : return (209 + $B0);
case  'SJ' : return (210 + $B0);
case  'SZ' : return (211 + $B0);
case  'SE' : return (212 + $B0);
case  'CH' : return (213 + $B0);
case  'SY' : return (214 + $B0);
case  'TW' : return (215 + $B0);
case  'TJ' : return (216 + $B0);
case  'TZ' : return (217 + $B0);
case  'TH' : return (218 + $B0);
case  'TL' : return (219 + $B0);
case  'TG' : return (220 + $B0);
case  'TK' : return (221 + $B0);
case  'TO' : return (222 + $B0);
case  'TT' : return (223 + $B0);
case  'TN' : return (224 + $B0);
case  'TR' : return (225 + $B0);
case  'TM' : return (226 + $B0);
case  'TC' : return (227 + $B0);
case  'TV' : return (228 + $B0);
case  'UG' : return (229 + $B0);
case  'UA' : return (230 + $B0);
case  'AE' : return (231 + $B0);
case  'GB' : return (232 + $B0);
case  'US' : return (233 + $B0);
case  'UM' : return (234 + $B0);
case  'UY' : return (235 + $B0);
case  'UZ' : return (236 + $B0);
case  'VU' : return (237 + $B0);
case  'VE' : return (238 + $B0);
case  'VN' : return (239 + $B0);
case  'VG' : return (240 + $B0);
case  'VI' : return (241 + $B0);
case  'WF' : return (242 + $B0);
case  'EH' : return (243 + $B0);
case  'YE' : return (244 + $B0);
case  'ZM' : return (245 + $B0);
case  'ZW' : return (246 + $B0);
endswitch;

    return 0;
}

